-- Create the database
CREATE DATABASE IF NOT EXISTS ppv_system;

-- Use the database
USE ppv_system;

-- Create access_codes table
CREATE TABLE IF NOT EXISTS access_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) NOT NULL UNIQUE,
    used_by VARCHAR(255) DEFAULT NULL,
    date_created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    date_used TIMESTAMP NULL
);

-- Create settings table
CREATE TABLE IF NOT EXISTS settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(50) NOT NULL UNIQUE,
    setting_value VARCHAR(255) NOT NULL
);

-- Insert default video ID if not exists
INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('active_video_id', 'e9n-o0I-W5w');