<?php
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params(['lifetime'=>7200,'httponly'=>true,'secure'=>(!empty($_SERVER['HTTPS'])&&$_SERVER['HTTPS']!=='off')||((int)($_SERVER['SERVER_PORT']??0)===443),'samesite'=>'Lax']);
session_start();
require_once __DIR__ . '/../config/db.php';

$ref = $_GET['ref'] ?? '';
$code = '';
$email = '';
$amount = 0;
$currency = 'NGN';

if ($ref) {
  try {
    $stmt = $pdo->prepare('SELECT email, code, amount, currency, status FROM purchases WHERE paystack_reference = ? LIMIT 1');
    $stmt->execute([$ref]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row && $row['status']==='success') {
      $code = $row['code'] ?: '';
      $email = $row['email'] ?: '';
      $amount = (int)$row['amount'];
      $currency = $row['currency'] ?: 'NGN';
    }
  } catch (PDOException $e) {}
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Thank You - PPV</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-200 min-h-screen">
  <div class="max-w-xl mx-auto px-4 py-12">
    <?php if ($code): ?>
      <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 text-center">
        <h1 class="text-3xl font-bold text-white mb-2">Payment Successful 🎉</h1>
        <p class="text-gray-300 mb-4">Reference: <span class="font-mono"><?php echo htmlspecialchars($ref); ?></span></p>
        <p class="text-gray-300 mb-6">We also sent your code to <span class="font-semibold"><?php echo htmlspecialchars($email); ?></span>.</p>
        <div class="bg-gray-900 border border-gray-700 rounded-lg p-4 inline-block">
          <p class="text-gray-400 text-sm mb-1">Your Access Code</p>
          <p class="text-2xl font-bold tracking-wider text-purple-300"><?php echo htmlspecialchars($code); ?></p>
        </div>
        <p class="text-gray-400 mt-4">Amount: <?php echo htmlspecialchars($currency); ?> <?php echo number_format($amount/100, 2); ?></p>
        <a href="index.php" class="mt-6 inline-block px-5 py-3 bg-purple-600 hover:bg-purple-700 rounded-lg text-white font-semibold">Go to Player</a>
      </div>
    <?php else: ?>
      <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 text-center">
        <h1 class="text-2xl font-bold text-white mb-2">Thank you</h1>
        <p class="text-gray-300">We could not find a successful transaction for reference <span class="font-mono"><?php echo htmlspecialchars($ref); ?></span>.</p>
        <p class="text-gray-400 mt-2">If you were charged, please contact support with your reference.</p>
        <a href="buy.php" class="mt-6 inline-block text-purple-400 hover:text-purple-300">Try Again →</a>
      </div>
    <?php endif; ?>
  </div>
</body>
</html>
