<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Service - PPV System</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-200">
    <div class="max-w-4xl mx-auto px-4 py-12">
        <h1 class="text-4xl font-bold text-white mb-8">Terms of Service</h1>
        <p class="text-sm text-gray-400 mb-8">Last Updated: <?= date('F d, Y') ?></p>
        
        <div class="space-y-6">
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">1. Acceptance of Terms</h2>
                <p>By accessing and using this pay-per-view streaming service, you accept and agree to be bound by these Terms of Service.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">2. Access Codes</h2>
                <p>Access codes are single-use and device-locked. Once activated, a code is tied to your device fingerprint. Sharing codes is prohibited and may result in termination of access.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">3. Content Usage</h2>
                <p>All video content is protected by copyright. You may not:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li>Record, download, or redistribute content</li>
                    <li>Use screen capture or recording software</li>
                    <li>Share your access with others</li>
                    <li>Attempt to bypass security measures</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">4. Account Security</h2>
                <p>You are responsible for maintaining the confidentiality of your access code. Notify us immediately if you suspect unauthorized use.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">5. Refund Policy</h2>
                <p>Access codes are non-refundable once activated. Technical issues will be addressed on a case-by-case basis.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">6. Service Availability</h2>
                <p>We strive for 99% uptime but do not guarantee uninterrupted service. Scheduled maintenance will be announced in advance when possible.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">7. Termination</h2>
                <p>We reserve the right to terminate access for violations of these terms, including but not limited to code sharing, content piracy, or abuse of the system.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">8. Limitation of Liability</h2>
                <p>We are not liable for any indirect, incidental, or consequential damages arising from use of this service.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">9. Changes to Terms</h2>
                <p>We may update these terms at any time. Continued use of the service constitutes acceptance of updated terms.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">10. Contact</h2>
                <p>For questions about these terms, contact: <a href="mailto:cetnetworks@gmail.com" class="text-purple-400 hover:text-purple-300">cetnetworks@gmail.com</a></p>
            </section>
        </div>
        
        <div class="mt-12 pt-6 border-t border-gray-700">
            <a href="index.php" class="text-purple-400 hover:text-purple-300">← Back to Home</a>
        </div>
    </div>
</body>
</html>
