<?php
// progress.php - load/save viewing progress
session_start();
header('Content-Type: application/json');

require_once '../config/db.php';
require_once '../includes/utils.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_SESSION['is_logged_in']) || empty($_SESSION['current_code'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'unauthorized']);
    exit;
}

$code = $_SESSION['current_code'];
$profileId = isset($_SESSION['profile_id']) ? (int)$_SESSION['profile_id'] : null;

if ($method === 'GET') {
    $videoId = isset($_GET['video']) ? trim($_GET['video']) : '';
    if ($videoId === '') {
        echo json_encode(['ok' => true, 'position' => 0]);
        exit;
    }
    try {
        if ($profileId) {
            $stmt = $pdo->prepare('SELECT position_seconds FROM viewing_progress WHERE code = ? AND video_id = ? AND profile_id = ?');
            $stmt->execute([$code, $videoId, $profileId]);
        } else {
            $stmt = $pdo->prepare('SELECT position_seconds FROM viewing_progress WHERE code = ? AND video_id = ? AND profile_id IS NULL');
            $stmt->execute([$code, $videoId]);
        }
        $pos = (int)($stmt->fetchColumn() ?: 0);
        echo json_encode(['ok' => true, 'position' => $pos]);
    } catch (PDOException $e) {
        error_log('Progress load error: ' . $e->getMessage());
        echo json_encode(['ok' => false, 'error' => 'db_error']);
    }
    exit;
}

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true) ?: [];
    $videoId = isset($input['video']) ? trim($input['video']) : '';
    $position = isset($input['position']) ? (int)$input['position'] : 0;
    if ($videoId === '' || $position < 0) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'bad_request']);
        exit;
    }
    try {
        if ($profileId) {
            $stmt = $pdo->prepare('INSERT INTO viewing_progress (code, video_id, profile_id, position_seconds, updated_at) VALUES (?, ?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE position_seconds = VALUES(position_seconds), updated_at = NOW()');
            $stmt->execute([$code, $videoId, $profileId, $position]);
        } else {
            $stmt = $pdo->prepare('INSERT INTO viewing_progress (code, video_id, position_seconds, updated_at) VALUES (?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE position_seconds = VALUES(position_seconds), updated_at = NOW()');
            $stmt->execute([$code, $videoId, $position]);
        }
        echo json_encode(['ok' => true]);
    } catch (PDOException $e) {
        error_log('Progress save error: ' . $e->getMessage());
        echo json_encode(['ok' => false, 'error' => 'db_error']);
    }
    exit;
}

echo json_encode(['ok' => false, 'error' => 'method_not_allowed']);
