<?php
// profile.php - create/select/list profiles for the current code
// Safer session config
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params([
    'lifetime' => 7200,
    'httponly' => true,
    'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443),
    'samesite' => 'Lax'
]);
session_start();
header('Content-Type: application/json');

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/utils.php';

if (!isset($_SESSION['is_logged_in']) || empty($_SESSION['current_code'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'unauthorized']);
    exit;
}

$code = $_SESSION['current_code'];
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    try {
        $stmt = $pdo->prepare('SELECT id, name, avatar_url FROM profiles WHERE code = ? ORDER BY created_at ASC');
        $stmt->execute([$code]);
        $profiles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $current = isset($_SESSION['profile_id']) ? (int)$_SESSION['profile_id'] : null;
        echo json_encode(['ok' => true, 'profiles' => $profiles, 'current' => $current]);
    } catch (PDOException $e) {
        error_log('Profile list error: ' . $e->getMessage());
        echo json_encode(['ok' => false, 'error' => 'db_error']);
    }
    exit;
}

$payload = json_decode(file_get_contents('php://input'), true) ?: [];
$action = isset($payload['action']) ? $payload['action'] : '';

if ($method === 'POST' && $action === 'create') {
    $name = trim($payload['name'] ?? '');
    $avatar = trim($payload['avatar'] ?? '');
    if ($name === '' || strlen($name) > 50) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'bad_name']);
        exit;
    }
    try {
        $stmt = $pdo->prepare('INSERT INTO profiles (code, name, avatar_url) VALUES (?, ?, ?)');
        $stmt->execute([$code, $name, $avatar ?: null]);
        $_SESSION['profile_id'] = (int)$pdo->lastInsertId();
        echo json_encode(['ok' => true, 'profile_id' => $_SESSION['profile_id']]);
    } catch (PDOException $e) {
        error_log('Profile create error: ' . $e->getMessage());
        echo json_encode(['ok' => false, 'error' => 'db_error']);
    }
    exit;
}

if ($method === 'POST' && $action === 'select') {
    $profileId = (int)($payload['profile_id'] ?? 0);
    if ($profileId <= 0) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'bad_profile']);
        exit;
    }
    try {
        $stmt = $pdo->prepare('SELECT id FROM profiles WHERE id = ? AND code = ?');
        $stmt->execute([$profileId, $code]);
        $exists = $stmt->fetchColumn();
        if ($exists) {
            $_SESSION['profile_id'] = $profileId;
            echo json_encode(['ok' => true]);
        } else {
            http_response_code(404);
            echo json_encode(['ok' => false, 'error' => 'not_found']);
        }
    } catch (PDOException $e) {
        error_log('Profile select error: ' . $e->getMessage());
        echo json_encode(['ok' => false, 'error' => 'db_error']);
    }
    exit;
}

echo json_encode(['ok' => false, 'error' => 'method_not_allowed']);
