<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - PPV System</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-200">
    <div class="max-w-4xl mx-auto px-4 py-12">
        <h1 class="text-4xl font-bold text-white mb-8">Privacy Policy</h1>
        <p class="text-sm text-gray-400 mb-8">Last Updated: <?= date('F d, Y') ?></p>
        
        <div class="space-y-6">
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">1. Information We Collect</h2>
                <h3 class="text-lg font-semibold text-purple-300 mt-4 mb-2">Automatically Collected:</h3>
                <ul class="list-disc ml-6 space-y-1">
                    <li>Device fingerprint (browser, OS, screen resolution)</li>
                    <li>IP address</li>
                    <li>Session data</li>
                    <li>Video viewing analytics (watch time, completion rate)</li>
                </ul>
                
                <h3 class="text-lg font-semibold text-purple-300 mt-4 mb-2">User Provided:</h3>
                <ul class="list-disc ml-6 space-y-1">
                    <li>Access codes</li>
                    <li>Profile names (optional)</li>
                    <li>Email addresses (for admin recovery only)</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">2. How We Use Your Information</h2>
                <ul class="list-disc ml-6 space-y-1">
                    <li>Authenticate and authorize access</li>
                    <li>Prevent unauthorized code sharing</li>
                    <li>Track viewing analytics for content optimization</li>
                    <li>Detect and prevent fraud</li>
                    <li>Send security notifications</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">3. Data Storage & Security</h2>
                <p>Your data is stored on secure servers with industry-standard encryption. We implement:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li>Encrypted database connections</li>
                    <li>Secure session management</li>
                    <li>Regular security audits</li>
                    <li>Access logging and monitoring</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">4. Cookies & Tracking</h2>
                <p>We use essential cookies for:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li>Session management</li>
                    <li>Authentication</li>
                    <li>User preferences</li>
                </ul>
                <p class="mt-2">We do not use third-party advertising or tracking cookies.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">5. Data Sharing</h2>
                <p>We do not sell, rent, or share your personal information with third parties except:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li>When required by law</li>
                    <li>To protect our rights or safety</li>
                    <li>With your explicit consent</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">6. Your Rights (GDPR Compliance)</h2>
                <p>You have the right to:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li><strong>Access:</strong> Request a copy of your data</li>
                    <li><strong>Rectification:</strong> Correct inaccurate data</li>
                    <li><strong>Erasure:</strong> Request deletion of your data</li>
                    <li><strong>Portability:</strong> Receive your data in a machine-readable format</li>
                    <li><strong>Objection:</strong> Object to processing of your data</li>
                </ul>
                <p class="mt-3">To exercise these rights, contact: <a href="mailto:cetnetworks@gmail.com" class="text-purple-400 hover:text-purple-300">cetnetworks@gmail.com</a></p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">7. Data Retention</h2>
                <p>We retain your data for:</p>
                <ul class="list-disc ml-6 mt-2 space-y-1">
                    <li>Active sessions: Duration of access</li>
                    <li>Analytics data: 24 months</li>
                    <li>Audit logs: 12 months</li>
                    <li>Inactive accounts: 90 days after last activity</li>
                </ul>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">8. Children's Privacy</h2>
                <p>This service is not intended for users under 13 years of age. We do not knowingly collect information from children.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">9. Changes to Privacy Policy</h2>
                <p>We may update this policy periodically. Material changes will be notified via email or prominent notice on the site.</p>
            </section>
            
            <section>
                <h2 class="text-2xl font-semibold text-white mb-3">10. Contact Us</h2>
                <p>For privacy concerns or data requests:</p>
                <p class="mt-2">Email: <a href="mailto:cetnetworks@gmail.com" class="text-purple-400 hover:text-purple-300">cetnetworks@gmail.com</a></p>
            </section>
        </div>
        
        <div class="mt-12 pt-6 border-t border-gray-700 flex justify-between">
            <a href="index.php" class="text-purple-400 hover:text-purple-300">← Back to Home</a>
            <a href="gdpr.php" class="text-purple-400 hover:text-purple-300">GDPR Data Request →</a>
        </div>
    </div>
</body>
</html>
