<?php
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params(['lifetime'=>7200,'httponly'=>true,'secure'=>(!empty($_SERVER['HTTPS'])&&$_SERVER['HTTPS']!=='off')||((int)($_SERVER['SERVER_PORT']??0)===443),'samesite'=>'Lax']);
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config/db.php';

$secretKey = getenv('PAYSTACK_SECRET_KEY') ?: '';
$publicKey = getenv('PAYSTACK_PUBLIC_KEY') ?: '';

// Fetch price from settings
$amountGhs = 100; // default
$currency = 'GHS'; // default
try {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'purchase_price' LIMIT 1");
    $stmt->execute();
    $price = $stmt->fetchColumn();
    if ($price !== false && $price !== null) $amountGhs = (float)$price;
    
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'purchase_currency' LIMIT 1");
    $stmt->execute();
    $curr = $stmt->fetchColumn();
    if ($curr !== false && $curr !== null) $currency = $curr;
} catch (PDOException $e) {}

$amountPesewas = $amountGhs * 100; // Paystack expects lowest denomination (pesewas/kobo)

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { echo json_encode(['ok'=>false,'error'=>'method_not_allowed']); exit; }
$payload = json_decode(file_get_contents('php://input'), true) ?: [];
$email = filter_var($payload['email'] ?? '', FILTER_VALIDATE_EMAIL);
$phone = trim($payload['phone'] ?? '');
if (!$email || $phone === '') { http_response_code(400); echo json_encode(['ok'=>false,'error'=>'invalid_input']); exit; }
if (!$secretKey) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'missing_paystack_key']); exit; }

$callbackUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https':'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/paystack_callback.php';

// Initialize transaction with Paystack
$initEndpoint = 'https://api.paystack.co/transaction/initialize';
$initBody = [
  'email' => $email,
  'amount' => $amountPesewas,
  'currency' => $currency,
  'callback_url' => $callbackUrl,
  'metadata' => [ 'phone' => $phone ],
  'channels' => ['card','mobile_money']
];

$ch = curl_init($initEndpoint);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  'Content-Type: application/json',
  'Authorization: Bearer ' . $secretKey
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($initBody));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$resp = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http < 200 || $http >= 300 || !$resp) {
  http_response_code(502);
  echo json_encode(['ok'=>false,'error'=>'paystack_unavailable']);
  exit;
}

$data = json_decode($resp, true);
if (!($data['status'] ?? false)) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'paystack_error','message'=>$data['message'] ?? '']);
  exit;
}

$authUrl = $data['data']['authorization_url'] ?? '';
$reference = $data['data']['reference'] ?? '';
if (!$authUrl || !$reference) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'bad_paystack_response']); exit; }

// Record purchase row
try {
  $stmt = $pdo->prepare('INSERT INTO purchases (email, phone, amount, currency, paystack_reference, status) VALUES (?, ?, ?, ?, ?, ? )');
  $stmt->execute([$email, $phone, $amountPesewas, $currency, $reference, 'initialized']);
} catch (PDOException $e) {
  // still allow redirect; but log
  error_log('purchase insert error: ' . $e->getMessage());
}

echo json_encode(['ok'=>true, 'authorization_url'=>$authUrl]);
