<?php
// Paystack callback: verify transaction, generate code, send email & SMS
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params(['lifetime'=>7200,'httponly'=>true,'secure'=>(!empty($_SERVER['HTTPS'])&&$_SERVER['HTTPS']!=='off')||((int)($_SERVER['SERVER_PORT']??0)===443),'samesite'=>'Lax']);
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/email.php';
require_once __DIR__ . '/../includes/sms.php';

$secretKey = getenv('PAYSTACK_SECRET_KEY') ?: '';
if (!$secretKey) { http_response_code(500); echo 'Missing Paystack secret key'; exit; }

$reference = $_GET['reference'] ?? '';
if ($reference === '') { http_response_code(400); echo 'Missing reference'; exit; }

// Verify with Paystack
$verifyUrl = 'https://api.paystack.co/transaction/verify/' . urlencode($reference);
$ch = curl_init($verifyUrl);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
  'Authorization: Bearer ' . $secretKey,
  'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$resp = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http < 200 || $http >= 300 || !$resp) {
  http_response_code(502);
  echo 'Could not verify payment. Please contact support with your reference: ' . htmlspecialchars($reference);
  exit;
}

$data = json_decode($resp, true);
if (!($data['status'] ?? false) || !isset($data['data'])) {
  http_response_code(400);
  echo 'Invalid verification response. Ref: ' . htmlspecialchars($reference);
  exit;
}

$tx = $data['data'];
$status = $tx['status'] ?? 'failed';
$email = $tx['customer']['email'] ?? '';
$amount = (int)($tx['amount'] ?? 0); // in kobo
$currency = $tx['currency'] ?? 'NGN';
$phone = '';
if (isset($tx['metadata']['phone'])) { $phone = $tx['metadata']['phone']; }

// Load purchase row (if any)
try {
  $stmt = $pdo->prepare('SELECT id, code, code_issued FROM purchases WHERE paystack_reference = ? LIMIT 1');
  $stmt->execute([$reference]);
  $purchase = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) { $purchase = null; }

// Helper to generate a unique code
function generate_code($pdo) {
  for ($i=0; $i<10; $i++) {
    $code = strtoupper(substr(bin2hex(random_bytes(4)), 0, 8));
    try {
      $stmt = $pdo->prepare('SELECT 1 FROM access_codes WHERE code = ?');
      $stmt->execute([$code]);
      if (!$stmt->fetchColumn()) return $code;
    } catch (PDOException $e) {}
  }
  return strtoupper(substr(bin2hex(random_bytes(5)), 0, 10));
}

$issuedCode = $purchase['code'] ?? null;

if ($status === 'success') {
  // If already issued, skip re-issuing
  if (!$issuedCode) {
    $code = generate_code($pdo);
    try {
      // create access code
      $stmt = $pdo->prepare('INSERT INTO access_codes (code, used_by, created_at) VALUES (?, NULL, NOW())');
      $stmt->execute([$code]);
      $issuedCode = $code;
    } catch (PDOException $e) {
      // If duplicate due to race, try again once
      $issuedCode = generate_code($pdo);
      try {
        $stmt = $pdo->prepare('INSERT INTO access_codes (code, used_by, created_at) VALUES (?, NULL, NOW())');
        $stmt->execute([$issuedCode]);
      } catch (PDOException $e2) {}
    }
  }

  // Update purchases table
  try {
    $stmt = $pdo->prepare('UPDATE purchases SET status = "success", verified_at = NOW(), code = ?, code_issued = 1 WHERE paystack_reference = ?');
    $stmt->execute([$issuedCode, $reference]);
  } catch (PDOException $e) {}

  // Send notifications
  $emailSvc = new EmailService($pdo);
  $smsSvc = new SMSService();
  $subject = 'Your PPV Access Code';
  $body = "<html><body style='font-family: Arial, sans-serif; color:#111'>
            <h2 style='color:#6B46C1'>Thank you for your purchase!</h2>
            <p>Your access code is: <strong style='font-size:18px'>{$issuedCode}</strong></p>
            <p>Keep this code safe. It will be linked to the first device that uses it.</p>
            <p>Amount: " . htmlspecialchars($currency) . ' ' . number_format($amount/100, 2) . "</p>
            <p>Reference: " . htmlspecialchars($reference) . "</p>
            <p><a href='" . ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')?'https':'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . "/../public/index.php" . "' style='color:#6B46C1'>Go to Player</a></p>
           </body></html>";
  if ($email) { $emailSvc->send($email, $subject, $body, true); }
  if ($phone) {
    $smsSvc->send($phone, "PPV: Your access code is {$issuedCode}. Ref: {$reference}");
  }

  // Redirect to thank you page
  $redirect = 'thank_you.php?ref=' . urlencode($reference);
  header('Location: ' . $redirect);
  exit;
}

// Failed or abandoned
try {
  if ($purchase) {
    $stmt = $pdo->prepare('UPDATE purchases SET status = "failed", verified_at = NOW() WHERE paystack_reference = ?');
    $stmt->execute([$reference]);
  }
} catch (PDOException $e) {}

echo 'Payment not successful. If you were charged, please contact support with reference: ' . htmlspecialchars($reference);
