<?php
// Export Access Codes as CSV
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params([
    'lifetime' => 7200,
    'httponly' => true,
    'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443),
    'samesite' => 'Lax'
]);
session_start();
require_once __DIR__ . '/../config/db.php';

// Admin only
if (!isset($_SESSION['is_admin'])) {
    http_response_code(403);
    die('Unauthorized');
}

try {
    $stmt = $pdo->query("SELECT code, used_by, created_at FROM access_codes ORDER BY created_at DESC");
    $codes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Set headers for CSV download
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=access_codes_' . date('Y-m-d_His') . '.csv');
    header('Pragma: no-cache');
    header('Expires: 0');
    
    $output = fopen('php://output', 'w');
    
    // CSV headers
    fputcsv($output, ['Code', 'Status', 'Used By (Fingerprint)', 'Created At']);
    
    // CSV rows
    foreach ($codes as $row) {
        fputcsv($output, [
            $row['code'],
            $row['used_by'] ? 'Used' : 'Unused',
            $row['used_by'] ?? 'N/A',
            $row['created_at']
        ]);
    }
    
    fclose($output);
    exit;
    
} catch (PDOException $e) {
    http_response_code(500);
    die('Export failed: ' . $e->getMessage());
}
