<?php
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params(['lifetime'=>7200,'httponly'=>true,'secure'=>(!empty($_SERVER['HTTPS'])&&$_SERVER['HTTPS']!=='off')||((int)($_SERVER['SERVER_PORT']??0)===443),'samesite'=>'Lax']);
session_start();
require_once __DIR__ . '/../config/db.php';

// Fetch price from settings
$priceGhs = 100; // default
$currency = 'GHS'; // default
try {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'purchase_price' LIMIT 1");
    $stmt->execute();
    $price = $stmt->fetchColumn();
    if ($price !== false && $price !== null) $priceGhs = (float)$price;
    
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'purchase_currency' LIMIT 1");
    $stmt->execute();
    $curr = $stmt->fetchColumn();
    if ($curr !== false && $curr !== null) $currency = $curr;
} catch (PDOException $e) {}

$publicKey = getenv('PAYSTACK_PUBLIC_KEY') ?: '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Purchase Access Code</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-200 min-h-screen">
  <div class="max-w-xl mx-auto px-4 py-10">
    <h1 class="text-3xl font-bold text-white mb-2">Purchase Access Code</h1>
    <p class="text-gray-400 mb-6">Pay <?php echo number_format($priceGhs); ?> <?php echo $currency; ?> to receive a unique access code via Email and SMS. You can pay with card or mobile money.</p>

    <div class="bg-gray-800 border border-gray-700 p-6 rounded-xl">
      <form id="buy-form" class="space-y-4">
        <div>
          <label class="block text-sm mb-1">Email</label>
          <input type="email" name="email" class="w-full p-3 rounded-lg bg-gray-900 border border-gray-700 text-white" placeholder="you@example.com" required>
        </div>
        <div>
          <label class="block text-sm mb-1">Phone (with country code)</label>
          <input type="tel" name="phone" class="w-full p-3 rounded-lg bg-gray-900 border border-gray-700 text-white" placeholder="+233201234567" required>
        </div>
        <div class="flex items-center justify-between">
          <div>
            <p class="text-gray-300">Amount</p>
            <p class="text-2xl font-semibold text-white">GH<?php echo number_format($priceGhs, 2); ?></p>
          </div>
          <button type="submit" class="px-5 py-3 bg-purple-600 hover:bg-purple-700 rounded-lg text-white font-semibold">Continue to Paystack</button>
        </div>
        <p id="err" class="text-red-400 text-sm hidden"></p>
      </form>
    </div>

    <p class="text-sm text-gray-500 mt-6">By purchasing, you agree to our <a href="terms.php" class="text-purple-400 hover:text-purple-300">Terms</a> and <a href="privacy.php" class="text-purple-400 hover:text-purple-300">Privacy Policy</a>.</p>

    <div class="mt-8">
      <a href="index.php" class="text-purple-400 hover:text-purple-300">← Back to Home</a>
    </div>
  </div>

  <script>
    (function(){
      const form = document.getElementById('buy-form');
      const err = document.getElementById('err');
      form.addEventListener('submit', async (e)=>{
        e.preventDefault(); err.classList.add('hidden');
        const fd = new FormData(form);
        const email = (fd.get('email')||'').toString().trim();
        const phone = (fd.get('phone')||'').toString().trim();
        try {
          const res = await fetch('paystack_init.php', { method:'POST', credentials:'same-origin', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ email, phone })});
          if (!res.ok) throw new Error('init_failed');
          const d = await res.json();
          if (!d.ok || !d.authorization_url) throw new Error('bad_response');
          window.location.href = d.authorization_url;
        } catch (e) {
          err.textContent = 'Could not initialize payment. Please try again later.';
          err.classList.remove('hidden');
        }
      });
    })();
  </script>
</body>
</html>
