<?php
// Video Analytics Tracking Endpoint
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params([
    'lifetime' => 7200,
    'httponly' => true,
    'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443),
    'samesite' => 'Lax'
]);
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../config/db.php';

$method = $_SERVER['REQUEST_METHOD'];

// Ensure analytics table exists
try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS video_views (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        video_id BIGINT UNSIGNED NOT NULL,
        code VARCHAR(20) NOT NULL,
        profile_id BIGINT UNSIGNED NULL,
        session_id VARCHAR(64) NOT NULL,
        started_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
        last_position INT UNSIGNED DEFAULT 0,
        watch_duration INT UNSIGNED DEFAULT 0,
        completed TINYINT(1) DEFAULT 0,
        device_info VARCHAR(255) NULL,
        PRIMARY KEY (id),
        INDEX idx_video (video_id),
        INDEX idx_code (code),
        INDEX idx_started (started_at),
        INDEX idx_session (session_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'db_init_failed']);
    exit;
}

if ($method === 'POST') {
    if (!isset($_SESSION['is_logged_in']) || empty($_SESSION['current_code'])) {
        http_response_code(401);
        echo json_encode(['ok' => false, 'error' => 'unauthorized']);
        exit;
    }

    $payload = json_decode(file_get_contents('php://input'), true) ?: [];
    $action = $payload['action'] ?? '';
    $youtubeId = preg_replace('/[^a-zA-Z0-9_-]/', '', $payload['video'] ?? '');
    
    if ($youtubeId === '') {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'bad_video']);
        exit;
    }

    // Get video_id from youtube_id
    try {
        $stmt = $pdo->prepare("SELECT id FROM videos WHERE youtube_id = ? LIMIT 1");
        $stmt->execute([$youtubeId]);
        $videoId = $stmt->fetchColumn();
        if (!$videoId) {
            http_response_code(404);
            echo json_encode(['ok' => false, 'error' => 'video_not_found']);
            exit;
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => 'db_error']);
        exit;
    }

    $sessionId = session_id();
    $code = $_SESSION['current_code'];
    $profileId = isset($_SESSION['profile_id']) ? (int)$_SESSION['profile_id'] : null;
    $deviceInfo = $_SERVER['HTTP_USER_AGENT'] ?? '';

    if ($action === 'start') {
        // Record video start
        try {
            $stmt = $pdo->prepare("INSERT INTO video_views (video_id, code, profile_id, session_id, device_info) 
                                   VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$videoId, $code, $profileId, $sessionId, $deviceInfo]);
            echo json_encode(['ok' => true, 'view_id' => $pdo->lastInsertId()]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['ok' => false, 'error' => 'db_error']);
        }
        exit;
    }

    if ($action === 'update') {
        // Update watch progress
        $position = max(0, (int)($payload['position'] ?? 0));
        $duration = max(0, (int)($payload['duration'] ?? 0));
        $completed = ($duration > 0 && $position >= ($duration * 0.9)) ? 1 : 0;
        
        try {
            $stmt = $pdo->prepare("UPDATE video_views 
                                   SET last_position = ?, 
                                       watch_duration = watch_duration + 15,
                                       completed = ?
                                   WHERE video_id = ? AND session_id = ? AND code = ?
                                   ORDER BY id DESC LIMIT 1");
            $stmt->execute([$position, $completed, $videoId, $sessionId, $code]);
            echo json_encode(['ok' => true]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['ok' => false, 'error' => 'db_error']);
        }
        exit;
    }
}

echo json_encode(['ok' => false, 'error' => 'method_not_allowed']);
